ServerEvents.recipes(e => {
    e.shaped('kubejs:infinite_energy', [
        'ABA',
        'BCB',
        'ABA'
    ], {
        A: 'minecraft:redstone_block',
        B: 'minecraft:gold_ingot',
        C: 'minecraft:coal_block'
    });

    e.shaped('kubejs:infinite_water', [
        ' A ',
        'BCB',
        ' A '
    ], {
        A: 'create:industrial_iron_block',
        B: 'minecraft:water_bucket',
        C: 'minecraft:bucket'
    });

    e.shaped('kubejs:infinite_milk', [
        ' A ',
        'BCB',
        ' A '
    ], {
        A: 'create:industrial_iron_block',
        B: 'minecraft:milk_bucket',
        C: 'minecraft:bucket'
    });

    e.shaped('kubejs:infinite_lava', [
        'BAB',
        'ACA',
        ' A '
    ], {
        A: 'create:industrial_iron_block',
        B: 'cataclysm:lava_power_cell',
        C: "minecraft:lava_bucket"
    });

    e.shaped(Item.of('irons_spellbooks:autoloader_crossbow', 
        '{Enchantments:[{id:"enigmaticlegacy:sharpshooter",lvl:10s},{id:"minecraft:quick_charge",lvl:5s},{id:"minecraft:piercing",lvl:10s},{id:"minecraft:looting",lvl:5s},{id:"enigmaticlegacy:ceaseless",lvl:1s},{id:"l2complements:ender_reach",lvl:1s}],Unbreakable:1.0d,AttributeModifiers:[{Amount:0.3d,AttributeName:"attributeslib:arrow_damage",Operation:0,Slot:"mainhand",UUID:[I;-1601652395,581322300,-1119851514,1642413196]}]}'), [
        'DCD',
        'EAE',
        ' B '
    ], {
        A: 'minecraft:crossbow',
        B: 'kubejs:infinite_energy',
        C: 'kubejs:package_arrow',
        D: 'farmersdelight:golden_knife',
        E: 'minecraft:diamond'
    });

    const create = e.recipes.create;

    create.mechanical_crafting('kubejs:infinite_lava', [
        "ABBBA",
        "BCCCB",
        "BDADB",
        "BCCCB",
        "ABBBA"
    ], {
        A: "minecraft:netherite_ingot",
        B: "create:sturdy_sheet",
        C: "create:industrial_iron_block",
        D: "minecraft:lava_bucket"
    });
    create.mechanical_crafting(Item.of('create:cardboard_helmet', 
        '{Enchantments:[{id:"minecraft:aqua_affinity",lvl:1s},{id:"minecraft:respiration",lvl:5s}],Unbreakable:1.0d}'), [
        " A ",
        "ABA",
        " C "
    ], {
        A: "#forge:glass",
        B: "create:cardboard_helmet",
        C: "create:sturdy_sheet"
    });
    create.mechanical_crafting(Item.of('create:cardboard_chestplate', 
        '{Enchantments:[{id:"minecraft:blast_protection",lvl:24s},{id:"minecraft:fire_protection",lvl:24s}],Unbreakable:1.0d}'), [
        "A A",
        "CBC",
        "ACA"
    ], {
        A: "create:industrial_iron_block",
        B: "create:cardboard_chestplate",
        C: "create:sturdy_sheet"
    });
    create.mechanical_crafting(Item.of('create:cardboard_leggings', 
        '{Enchantments:[{id:"minecraft:swift_sneak",lvl:5s}],Unbreakable:1.0d}'), [
        "ABA",
        "A A",
        "C C"
    ], {
        A: "create:sturdy_sheet",
        B: "create:cardboard_leggings",
        C: "create:encased_fan"
    });
    create.mechanical_crafting(Item.of('create:cardboard_boots', 
        '{Enchantments:[{id:"minecraft:depth_strider",lvl:5s},{id:"minecraft:soul_speed",lvl:5s},{id:"minecraft:feather_falling",lvl:24s}],Unbreakable:1.0d}'), [
        "A A",
        "CBC",
        "C C"
    ], {
        A: "minecraft:soul_sand",
        B: "create:cardboard_boots",
        C: "create:sturdy_sheet"
    });

    const incomplete_infinite = "kubejs:incomplete_infinite";

    create.sequenced_assembly(
        Item.of("kubejs:infinite_honey"),
        "create:industrial_iron_block",
        [
            create.filling(incomplete_infinite, [incomplete_infinite, Fluid.of("create:honey", 500)])
        ]
    )
    .transitionalItem(incomplete_infinite)
    .loops(64);
    
    create.sequenced_assembly(
        Item.of("kubejs:infinite_lava"),
        "create:industrial_iron_block",
        [
            create.filling(incomplete_infinite, [incomplete_infinite, Fluid.of("minecraft:lava", 1000)])
        ]
    )
    .transitionalItem(incomplete_infinite)
    .loops(1200);

    create.sequenced_assembly(
        Item.of("kubejs:infinite_chocolate"),
        "create:industrial_iron_block",
        [
            create.filling(incomplete_infinite, [incomplete_infinite, Fluid.of("create:chocolate", 1000)])
        ]
    )
    .transitionalItem(incomplete_infinite)
    .loops(32);

    create.sequenced_assembly(
        Item.of("kubejs:infinite_tea"),
        "create:industrial_iron_block",
        [
            create.filling(incomplete_infinite, [incomplete_infinite, Fluid.of("create:tea", 250)])
        ]
    )
    .transitionalItem(incomplete_infinite)
    .loops(81);
});

ServerEvents.tags('item', event => {
    event.add('farmersdelight:tools/knives', 'irons_spellbooks:autoloader_crossbow')
    event.add('curios:eye', 'endrem:wither_eye')
});
ServerEvents.tags('block', event => {
    event.add('create:fan_processing_catalysts/blasting', 'minecraft:magma_block')
    event.add('create:fan_transparent', 'minecraft:magma_block')
});